/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.RuleHelper;
import carpet.api.settings.SettingsManager;
import carpet.script.CarpetContext;
import carpet.script.CarpetScriptHost;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_1928;
import net.minecraft.class_241;
import net.minecraft.class_2784;
import net.minecraft.class_5217;
import net.minecraft.class_5218;

public class SystemInfo {
    private static final Map<String, Function<CarpetContext, Value>> options = new HashMap<String, Function<CarpetContext, Value>>(){
        {
            this.put("app_name", c -> {
                String name = c.host.getName();
                return name == null ? Value.NULL : new StringValue(name);
            });
            this.put("app_list", c -> ListValue.wrap(((CarpetScriptHost)c.host).scriptServer().modules.keySet().stream().filter(Objects::nonNull).map(StringValue::new).collect(Collectors.toList())));
            this.put("app_scope", c -> StringValue.of(c.host.isPerUser() ? "player" : "global"));
            this.put("app_players", c -> ListValue.wrap(c.host.getUserList().stream().map(StringValue::new).collect(Collectors.toList())));
            this.put("world_name", c -> new StringValue(c.s.method_9211().method_27728().method_150()));
            this.put("world_seed", c -> new NumericValue(c.s.method_9225().method_8412()));
            this.put("server_motd", c -> StringValue.of(c.s.method_9211().method_3818()));
            this.put("world_path", c -> StringValue.of(c.s.method_9211().method_27050(class_5218.field_24188).toString()));
            this.put("world_folder", c -> {
                Path serverPath = c.s.method_9211().method_27050(class_5218.field_24188);
                int nodeCount = serverPath.getNameCount();
                if (nodeCount < 2) {
                    return Value.NULL;
                }
                String tlf = serverPath.getName(nodeCount - 2).toString();
                return StringValue.of(tlf);
            });
            this.put("world_dimensions", c -> ListValue.wrap(c.s.method_9211().method_29435().stream().map(k -> ValueConversions.of(k.method_29177())).collect(Collectors.toList())));
            this.put("world_spawn_point", c -> {
                class_5217 prop = c.s.method_9211().method_30002().method_8401();
                return ListValue.of(NumericValue.of(prop.method_215()), NumericValue.of(prop.method_144()), NumericValue.of(prop.method_166()));
            });
            this.put("world_bottom", c -> new NumericValue(c.s.method_9225().method_31607()));
            this.put("world_top", c -> new NumericValue(c.s.method_9225().method_31600()));
            this.put("world_center", c -> {
                class_2784 worldBorder = c.s.method_9225().method_8621();
                return ListValue.fromTriple(worldBorder.method_11964(), 0.0, worldBorder.method_11980());
            });
            this.put("world_size", c -> new NumericValue(c.s.method_9225().method_8621().method_11965() / 2.0));
            this.put("world_max_size", c -> new NumericValue(c.s.method_9225().method_8621().method_11959()));
            this.put("world_time", c -> new NumericValue(c.s.method_9225().method_8510()));
            this.put("game_difficulty", c -> StringValue.of(c.s.method_9211().method_27728().method_207().method_5460()));
            this.put("game_hardcore", c -> BooleanValue.of(c.s.method_9211().method_27728().method_152()));
            this.put("game_storage_format", c -> StringValue.of(c.s.method_9211().method_27728().method_27440(c.s.method_9211().method_27728().method_168())));
            this.put("game_default_gamemode", c -> StringValue.of(c.s.method_9211().method_3790().method_8381()));
            this.put("game_max_players", c -> new NumericValue(c.s.method_9211().method_3802()));
            this.put("game_view_distance", c -> new NumericValue(c.s.method_9211().method_3760().method_14568()));
            this.put("game_mod_name", c -> StringValue.of(c.s.method_9211().getServerModName()));
            this.put("game_version", c -> StringValue.of(c.s.method_9211().method_3827()));
            this.put("game_target", c -> StringValue.of(class_155.method_16673().getReleaseTarget()));
            this.put("game_protocol", c -> NumericValue.of(class_155.method_31372()));
            this.put("game_major_target", c -> {
                String[] vers = class_155.method_16673().getReleaseTarget().split("\\.");
                return NumericValue.of(vers.length > 1 ? Integer.parseInt(vers[1]) : 0);
            });
            this.put("game_minor_target", c -> {
                String[] vers = class_155.method_16673().getReleaseTarget().split("\\.");
                return NumericValue.of(vers.length > 2 ? Integer.parseInt(vers[2]) : 0);
            });
            this.put("game_stable", c -> BooleanValue.of(class_155.method_16673().isStable()));
            this.put("game_data_version", c -> NumericValue.of(class_155.method_16673().getWorldVersion()));
            this.put("game_pack_version", c -> NumericValue.of(class_155.method_16673().getPackVersion()));
            this.put("server_ip", c -> StringValue.of(c.s.method_9211().method_3819()));
            this.put("server_whitelisted", c -> BooleanValue.of(c.s.method_9211().method_3729()));
            this.put("server_whitelist", c -> {
                MapValue whitelist = new MapValue(Collections.emptyList());
                for (String s : c.s.method_9211().method_3760().method_14560()) {
                    whitelist.append(StringValue.of(s));
                }
                return whitelist;
            });
            this.put("server_banned_players", c -> {
                MapValue whitelist = new MapValue(Collections.emptyList());
                for (String s : c.s.method_9211().method_3760().method_14563().method_14636()) {
                    whitelist.append(StringValue.of(s));
                }
                return whitelist;
            });
            this.put("server_banned_ips", c -> {
                MapValue whitelist = new MapValue(Collections.emptyList());
                for (String s : c.s.method_9211().method_3760().method_14585().method_14636()) {
                    whitelist.append(StringValue.of(s));
                }
                return whitelist;
            });
            this.put("server_dev_environment", c -> BooleanValue.of(FabricLoader.getInstance().isDevelopmentEnvironment()));
            this.put("server_mods", c -> {
                HashMap<Value, Value> ret = new HashMap<Value, Value>();
                for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                    ret.put(new StringValue(mod.getMetadata().getId()), new StringValue(mod.getMetadata().getVersion().getFriendlyString()));
                }
                return MapValue.wrap(ret);
            });
            this.put("server_last_tick_times", c -> {
                int currentReportedTick = c.s.method_9211().method_3780() - 1;
                ArrayList<Value> ticks = new ArrayList<Value>(100);
                long[] tickArray = c.s.method_9211().field_4573;
                for (int i = currentReportedTick + 100; i > currentReportedTick; --i) {
                    ticks.add(new NumericValue((double)tickArray[i % 100] / 1000000.0));
                }
                return ListValue.wrap(ticks);
            });
            this.put("java_max_memory", c -> new NumericValue(Runtime.getRuntime().maxMemory()));
            this.put("java_allocated_memory", c -> new NumericValue(Runtime.getRuntime().totalMemory()));
            this.put("java_used_memory", c -> new NumericValue(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
            this.put("java_cpu_count", c -> new NumericValue(Runtime.getRuntime().availableProcessors()));
            this.put("java_version", c -> StringValue.of(System.getProperty("java.version")));
            this.put("java_bits", c -> {
                for (String property : new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
                    String value = System.getProperty(property);
                    if (value == null || !value.contains("64")) continue;
                    return new NumericValue(64L);
                }
                return new NumericValue(32L);
            });
            this.put("java_system_cpu_load", c -> {
                OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
                return new NumericValue(osBean.getCpuLoad());
            });
            this.put("java_process_cpu_load", c -> {
                OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
                return new NumericValue(osBean.getProcessCpuLoad());
            });
            this.put("world_carpet_rules", c -> {
                Collection<CarpetRule<?>> rules = CarpetServer.settingsManager.getCarpetRules();
                MapValue carpetRules = new MapValue(Collections.emptyList());
                rules.forEach((? super T rule) -> carpetRules.put(new StringValue(rule.name()), new StringValue(RuleHelper.toRuleString(rule.value()))));
                CarpetServer.extensions.forEach((? super T e) -> {
                    SettingsManager manager = e.extensionSettingsManager();
                    if (manager == null) {
                        return;
                    }
                    Collection<CarpetRule<?>> extensionRules = manager.getCarpetRules();
                    extensionRules.forEach((? super T rule) -> carpetRules.put(new StringValue(manager.identifier() + ":" + rule.name()), new StringValue(RuleHelper.toRuleString(rule.value()))));
                });
                return carpetRules;
            });
            this.put("world_gamerules", c -> {
                final HashMap<Value, Value> rules = new HashMap<Value, Value>();
                final class_1928 gameRules = c.s.method_9225().method_8450();
                class_1928.method_20744((class_1928.class_4311)new class_1928.class_4311(){

                    public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                        rules.put(StringValue.of(key.method_20771()), StringValue.of(gameRules.method_20746(key).toString()));
                    }
                });
                return MapValue.wrap(rules);
            });
            this.put("source_entity", c -> EntityValue.of(c.s.method_9228()));
            this.put("source_position", c -> ValueConversions.of(c.s.method_9222()));
            this.put("source_dimension", c -> ValueConversions.of(c.s.method_9225()));
            this.put("source_rotation", c -> {
                class_241 rotation = c.s.method_9210();
                return ListValue.of(new NumericValue(rotation.field_1343), new NumericValue(rotation.field_1342));
            });
            this.put("scarpet_version", c -> StringValue.of("1.4.84+v221018"));
        }
    };

    public static Value get(String what, CarpetContext cc) {
        return options.getOrDefault(what, c -> null).apply(cc);
    }

    public static Value getAll() {
        return ListValue.wrap(options.keySet().stream().map(StringValue::of).collect(Collectors.toList()));
    }
}

